# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 4
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR4_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR4(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Initial move: Cooperate
    if current_round == 1:
        return "C"
    
    # Check for deterministic opponent strategies
    always_cooperate = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower()
    always_defect = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower()
    
    if always_defect:
        return "D"
    if always_cooperate and current_round >= 2:
        return "D"
    
    # If opponent is not deterministic, implement adaptive strategy
    if current_round == total_rounds or current_round == total_rounds - 1:
        # Late-game defection if opponent has shown forgiveness
        if len(opp_history) >= 3 and opp_history[-1] == "C" and opp_history[-2] == "C":
            return "D"
        else:
            return opp_history[-1]
    
    # Check for unprovoked defection after mutual cooperation
    if len(my_history) >= 2 and len(opp_history) >= 2:
        if my_history[-2] == "C" and opp_history[-2] == "C" and opp_history[-1] == "D":
            # Trigger strategy: defect for two rounds
            if current_round <= len(my_history) + 2:
                return "D"
            else:
                return "C"
    
    # Tit-for-Tat with forgiveness
    if len(opp_history) >= 1:
        if opp_history[-1] == "D":
            # Occasionally forgive after mutual defection
            if len(my_history) >= 1 and my_history[-1] == "D":
                if current_round % 3 == 0:  # Forgive every 3rd mutual defection
                    return "C"
                else:
                    return "D"
            else:
                return "D"
        else:
            return "C"
    
    # Default to cooperate if no other conditions met
    return "C"